

function globalColumnView(name)
{
	return {
		nsClass: "GXColumnView",
		gxValueKey: "columnSpecs." + name,
		gxCopyValues: true,
		axIsIgnored: false,
		axRoleDescription: "Column heading",
		gxLayout: [
			"V:|-0-[self(15)]",
			"H:|-0-[self]",
		],
		gxForePainter:
		{
			"+": "LabelFore.size11.left",
			gxFontColor: "ForeColor3",
			up: {
				gxFontWeight: 0.23, // medium fontweight
				gxFontColor: "ForeColor2",
				gxEdgeInsets: "0, 0, 17, 0",
			},
			down: {
				gxFontWeight: 0.23, // medium fontweight
				gxFontColor: "ForeColor2",
				gxEdgeInsets: "0, 0, 17, 0",
		   },
		},
		gxBackPainter: {
			"+": "ImagePainter.right.foreColor2.chevron",	// chevron doesn't exist - 'chevron.up' and 'chevron.down' do
			gxEdgeInsets: "0, 2, 6, 0",
		},
	};
}


markup.push({


// MARK: global model

 GlobalModel:
 {
	 gxLeftWidth: 15,
	 gxRightWidth: 14,
	 gxColumnSpecs:
	 [
		 columnSpec("name", "Name", 130, 60, 300, false, "name", true, true),	 	// last true = prevent user hiding,
		 sizerSpec("nameSizer"),

		 columnSpec("sources", "Sources", 80, 50, 130, true),
		 sizerSpec("sourcesSizer"),

		 columnSpec("timers", "Timers", 40, 40, 80, true, "timersCount", false),
		 sizerSpec("timersSizer"),

		 columnSpec("recordings", "Recordings", 60, 40, 80, true, "recordingsCount", false),
		 sizerSpec("recordingsSizer"),

		 columnSpec("meter", "Meter", 88, 35, 200, false),
		 sizerSpec("meterSizer"),

		 columnSpec("globalStatus", "Status", 87, 87, 140, false, "statusSortValue"),
		 sizerSpec("globalStatusSizer"),

		 columnSpec("control", "Run", 48, 40, 90, false),
		 sizerSpec("controlSizer"),
	 ],
 },

	
// MARK: - menu item

// the one special menu item we add to our status item menu
GlobalMenuItemView:
{
	nsClass: "GXMenuItemView",
	gxFrameRect: "0, 0, 400, 250",
	axTitle: "Global Sessions List",
	axIsIgnored: false,
	gxLayout:
	[
		// note: width of menu item is set in code to match our end guide.
		// height is set in code to match these vertical constraints and item heights!
		"V:|-7-[title(16)]-11-[divider(1)]-4-[headings(20)]-0-[sessionsScrollView]-0-|",

		"H:|-40-[title]-10-[homeBtn(18)]-12-|",
		
		"V:|-5-[homeBtn(18)]",
		
		"V:|-5-[detachBtn(20)]",
		"H:|-12-[detachBtn(20)]",

		"H:|-0-[divider]-0-|",
		"H:|-0-[headings]-0-|",
		"H:|-0-[sessionsScrollView]-0-|",
		
		"H:[self]-(<=0)-[emptyView(340)]&alignCenterY",	// center
		"V:[self]-(<=0)-[emptyView(180)]&alignCenterX",	// center
	],
	gxChildViews:
	{
		detachBtn: {
			"+": "RoundIconButton.popover.pin",
			gxToolTip: "Detach",
			//axTitle: "Detach as pinned floating window"
			axIsIgnored: true,
		},
		title: {
			"+": "LabelView.foreColor1.size13.noPressed",
			gxDefaultValue: "Audio Hijack Sessions",
			axIsIgnored: true,
			gxIntrinsicWidth: -1,
		},
		homeBtn:
		{
			"+": "ImageButtonView.foreColor2.home",
			axTitle: "Open Home Window",
		},
		divider: filledView("BackColor3"),
		headings: {
			"+": "GlobalMenuItemHeadings",
			gxIntrinsicWidth: -1,
		},
		emptyView: {
			"+": "EmptyGlobalView"
		},
		sessionsScrollView:
		{
			nsClass: "GXScrollView",
			gxIntrinsicWidth: -1,
			gxVScrollbar: "ScrollBarView",    // vertical scroller only
			gxScrollbarWidth: 12,
			gxAddViewBelow: true,
			axIsIgnored: true,
			gxDocumentView:
			{
				// MARK: : list view
				nsClass: "GXListView",
				gxViewName: "sessionsList",
				gxCopyValues: true, // subModels is a mutable list, we need GXHelper to copy it when it changes
				gxDeleteKey: "deleteFromMenu",
				gxListItemView: "GlobalSessionListItem",
				gxItemHeight: 33,
				gxInterItemHeight: 1,
				gxTopHeight: 3,
				gxBottomHeight: 4,
				gxLayout: "H:|-0-[self]-0-|",
				axIsIgnored: true,
				axTitle: "Sessions",
				axHelp: "List of all sessions",
				axRoleDescription: "list",
			}
		},
	},
},

// --------------------------------------------------------
// MARK: menu item headings

 GlobalMenuItemHeadings:
 {
	 nsClass: "GXDrawView",
	 gxModelKeyPath: "columnsModel",
	 gxShowOnKey: "owner.headingsShown",
	 gxBackPainter: {
		 nsClass: "GXPainter",
		 gxFrameColor: "BackColor3",
		 gxEdgeInsets: "-1, -1, -1, 0",
	 },
	 axIsIgnored: false,
	 axDescription: "Session list column headings",
	 gxChildViews:
	 {
		 nameHdr: globalColumnView("name"),
		 nameSizer: sizerView("nameSizer", false),
		 sourcesHdr: globalColumnView("sources"),
		 sourcesSizer: sizerView("sourcesSizer", false),
		 globalStatusHdr: globalColumnView("globalStatus"),
		 globalStatusSizer: sizerView("globalStatusSizer", false),
		 meterHostViewHdr: globalColumnView("meter"),
		 meterSizer: sizerView("meterSizer", false),
		 runBtnHdr: globalColumnView("control"),
		 controlSizer: sizerView("controlSizer", false),
		 recordingsHdr: globalColumnView("recordings"),
		 recordingsSizer: sizerView("recordingsSizer", false),
		 timersHdr: globalColumnView("timers"),
		 timersSizer: sizerView("timersSizer", false),
		 endGuide: {
			 nsClass: "GXSplitterView",
			 gxValueKey: "endGuideSpec",
			 gxCopyValues: true,
			 gxLayout: [
				 "V:|-(-1)-[self(0)]",
				 "H:|-999-[self(0)]",
			 ],
			 gxBackPainter: fillPainter("BlackColor"),
		 },
	 }
 },

	
// MARK: - popover

GlobalWindow:
{
	nsClass: "GXWindow",
	gxWindowMaxSize: "2500, 2000",
	gxWindowMinSize: "40, 116",
	gxBackColor: "BackColor1",
	gxWindowStyleMask: 0,
	gxContentView: "GlobalWindowContentView",
	gxSavedWindowStateKey: "globalWindow",
	gxFullSizeContentView: true,
},


GlobalWindowContentView:
{
	nsClass: "GXDrawView",
	gxBackPainter:
	{
		nsClass: "GXPainter",
		gxFillColor: "SidebarBackColor2",
		lightMode: {
			gxFillColor: "SidebarBackColor1",
		},
	},
	gxLayout:
	[
		"V:|-12-[title(16)]-11-[divider(1)]-3-[headings(21)]-0-[sessionsScrollView]-7-|",

		"H:|-40-[title]-10-[homeBtn(18)]-12-|",
		
		"V:|-10-[homeBtn(18)]",

		"V:|-10-[pinBtn(20)]",
		"H:|-12-[pinBtn(20)]",

		"H:|-0-[divider]-0-|",
		"H:|-0-[sessionsScrollView]-0-|",

		"H:|-0-[headings]-0-|",
		"H:|-0-[self]-0-[endGuide]",		// window is sized to our column endGuide view!
				
		"H:[self]-(<=0)-[emptyView(340)]&alignCenterY",	// center
		"V:[self]-(<=0)-[emptyView(180)]&alignCenterX",	// center
	],
	gxChildViews:
	{
		pinBtn: { "+": "PinButton" },
		title: {
			"+": "LabelView.foreColor1.size13.noPressed",
			gxDefaultValue: "Audio Hijack Sessions",
			axIsIgnored: true,
			gxIntrinsicWidth: -1,
		},
		homeBtn:
		{
			"+": "ImageButtonView.foreColor2.home",
			axTitle: "Open Home Window",
		},
		divider: filledView("BackColor3"),
		headings: {
			"+": "GlobalListHeadings",
			gxIntrinsicWidth: -1,
		},
		emptyView: { "+": "EmptyGlobalView" },
		sessionsScrollView:
		{
			nsClass: "GXScrollView",
			gxFillColor: "SidebarBackColor2",
			lightMode: {
				gxFillColor: "SidebarBackColor1",
			},
			gxVScrollbar: "ScrollBarView",	// vertical scroller only
			gxScrollbarWidth: 12,
			gxIntrinsicWidth: -1,
			gxAddViewBelow: true,
			gxDocumentView:
			{
				// MARK: : list view
				nsClass: "GXListView",
				gxViewName: "sessionsList",
				gxCopyValues: true, // subModels is a mutable list, we need GXHelper to copy it when it changes
				gxDeleteKey: "deleteFromPopover",
				gxListItemView: "GlobalSessionListItem",
				gxItemHeight: 33,
				gxInterItemHeight: 1,
				gxTopHeight: 3,
				gxBottomHeight: 4,
				gxLayout: "H:|-0-[self]-0-|",
				axIsIgnored: false,
				axTitle: "Sessions",
				axHelp: "List of all sessions",
				axRoleDescription: "list",
			}
		},
	}
},


// --------------------------------------------------------
// MARK: popover headings

 GlobalListHeadings:
 {
	 nsClass: "GXDrawView",
	 gxModelKeyPath: "columnsModel",
	 gxShowOnKey: "owner.headingsShown",
	 gxBackPainter: {
		 nsClass: "GXPainter",
		 gxFrameColor: "BackColor3",
		 gxEdgeInsets: "-1, -1, -1, 0",
	 },
	 axIsIgnored: true,
	 //axDescription: "Session list column headings",
	 gxLayout: [
		 "V:|-0-[columnsMenu(18)]",
		 "H:[columnsMenu(17)]-2-|",
	 ],
	 gxChildViews:
	 {
		 nameHdr: globalColumnView("name"),
		 nameSizer: sizerView("nameSizer"),
		 sourcesHdr: globalColumnView("sources"),
		 sourcesSizer: sizerView("sourcesSizer"),
		 globalStatusHdr: globalColumnView("globalStatus"),
		 globalStatusSizer: sizerView("globalStatusSizer"),
		 meterHostViewHdr: globalColumnView("meter"),
		 meterSizer: sizerView("meterSizer"),
		 runBtnHdr: globalColumnView("control"),
		 controlSizer: sizerView("controlSizer"),
		 recordingsHdr: globalColumnView("recordings"),
		 recordingsSizer: sizerView("recordingsSizer"),
		 timersHdr: globalColumnView("timers"),
		 timersSizer: sizerView("timersSizer"),
		 endGuide: {
			 nsClass: "GXSplitterView",
			 gxValueKey: "endGuideSpec",
			 gxCopyValues: true,
			 gxLayout: [
				 "V:|-(-1)-[self(0)]",
				 "H:|-999-[self(0)]",		// 999 - must be wide enough to not cause unsatisfiable constraints before it is set by GXColumnSpec value
			 ],
		 },
		 columnsMenu:
		 {
			 nsClass: "GXPopupMenuView",
			 gxForePainter: {
				 "+": "ImagePainter.foreColor2.icon-columns",
				gxEdgeInsets: "1, 1, 1, 1",
			 },
			 gxBackPainter: {
				nsClass: "GXCirclePainter",
				hover: { gxFillColor: "BackColor3" },
				lightMode: {
					hover: { gxFillColor: "SidebarBackColor2" },
				},
				gxDiameter: 17,
			 },
			 gxPullsDown: true,
			 gxMenuItemsKeyPath: "columnsMenuItems",
			 axTitle: "Select Columns",
			 gxHideOnNilValue: false,
			 gxLayerZPosition: 10,
		 },
	 }
 },

	
// MARK: - global list items

GlobalSessionListItem:
{
	nsClass: "GXListItemView",
	gxViewName: "globalSessionItem",
	gxSelectable: 2,
	gxDoubleClickKey: "sessionItemDoubleClick",
	gxMenuItemsKeyPath:	"sessionItemMenuItems",
	gxIntrinsicWidth: -1,
	gxIntrinsicHeight: 33,
	gxLayerZPosition: 10,
	axIsIgnored: false,
	axRoleDescription: "Session list item",
	axDescriptionKeyPath: "accessibilityDescription",
	axHelp: "VO press to open the session window. Interact for more controls.",
	gxBackPainter: {
		nsClass: "GXPainter",
		gxEdgeInsets: "6, 0, 4, 0",
		gxCornerRadius: 9,
		selected: { gxFillColor: "SelectionColor3.alpha30" },
	},
	gxLateLayout:
	[
		"V:|-(-999)-[self(33)]",	// vertical position set by parent

		"H:|-0-[self]-0-|",

		"V:|-8-[name]",
		"V:|-0-[globalStatus(33)]",
		"V:|-4-[meterHostView(26)]",
		"V:|-7-[runBtn(19)]",

		"V:|-5-[sources(24)]",
		"V:|-8-[recordings]",
		"V:|-8-[timers]",
	],
	gxChildViews:
	{
		name: {
			"+": "LabelView.size13.foreColor1.mediumWeight.left",
			gxValueKey: "name",
			gxLateLayout: 	layoutForColumn("name"),
			axTitle: "Session Title",
			axIsIgnored: false,
		},
		sources: {
			"+": "LabelView.foreColor1.clip.useMarkup.left.size14",
			gxValueKey: "graph.graphSources",
			gxLateLayout: 	layoutForColumn("sources"),
			gxIntrinsicWidth: -1,
		},
		globalStatus:
		{
			"+": "LabelView",
			//gxAnimateOnKey: "animateStatusText",
			gxLateLayout: 	layoutForColumn("globalStatus"),
			axTitle: "Status",
			gxForePainter: {
				"+": "LabelFore.useMarkup.showAnimating.showSelected.centery.right",
				gxEdgeInsets: "0, 0, 22, 0",
			},
			axIsIgnored: false,
			gxChildViews:
			{
				spinnerHost: {
					nsClass: "GXLayerHostingView",
					gxLateLayout: 	[
						"H:[self(18)]-0-|",
						"V:|-10-[self(18)]",
					],
					gxRootLayer:
					{
						nsClass: "GXCaarLayer",
						gxViewName: "spinner",
						gxAnimateOnKey: "running",
						gxHideOnNilValue: true,
						gxAnimationDivider: 2,
						gxCaarPainter: "RecordingSpinnerPainter",
					}
				},
			},
		},
		meterHostView:
		{
			nsClass: "GXLayerHostingView",
			gxLayerZPosition: 2,
			gxLateLayout: 	layoutForColumn("meterHostView"),
			gxRootLayer:
			{
				nsClass: "AH4SpecMeterLayer",
				gxValueKey: "specData",
				gxAnimateOnKey: "graph.started",
				gxAnimationDivider: 2,
				gxForePainter: {
					nsClass: "GXPainter",
					gxFillColor: "ColorThemeLive2",
				},
			}
		},
		runBtn: {
			"+": "RunButton.size12.smallEnds",
			gxLateLayout: 	layoutForColumn("runBtn"),
		},
		recordings: {
			"+": "LabelView.centerx.foreColor2.showSelected.size12",
			gxValueKey: "recordingsCount",
			gxLateLayout: 	layoutForColumn("recordings"),
			axIsIgnored: false,
			axTitle: "Recordings Count",
			gxFormatter: { nsClass: "GXScaledFormatter", format: "%.0f", zeroFormat: "\u22C5" },
		},
		timers: {
			"+": "LabelView.centerx.foreColor2.showSelected.size12",
			gxValueKey: "timersCount",
			gxLateLayout: 	layoutForColumn("timers"),
			axIsIgnored: false,
			axTitle: "Timers Count",
			gxFormatter: { nsClass: "GXScaledFormatter", format: "%.0f", zeroFormat: "\u22C5" },
		},
	}
},

	
// MARK: - empty view

EmptyGlobalView:
{
	nsClass: "GXDrawView",
	gxLayerZPosition: 10,
	axIsIgnored: false,
	axDescription: "No Sessions Yet. Open the home window to create a session.",
	gxLayout:
	[
		"V:|-60-[label(40)]",
		"H:|-0-[label]-0-|",
			
		"V:[label]-30-[newBtn]",
		"H:[newBtn(107)]",
		"V:[self]-(<=0)-[newBtn]&alignCenterX",
	],
	gxChildViews:
	{
		label: labelView("<mediumWeight>No Sessions Yet</mediumWeight><size4>\n\n</size4><size11>Sessions you create will be displayed here.", "foreColor3.useMarkup.wrap.centerx.size14"),
		newBtn: {
			"+": "PlusButton",
			gxTitle: "<plusButton/> New Session",
			axDescription: "New session",
		},
	},
},

	
	
})
